%------------------------------------------------------------------------------
% File     : LCL623^1 : TPTP v7.4.0. Bugfixed v7.3.0.
% Domain   : Logical Calculi
% Problem  : The Loeb formula is a theorem in GL
% Version  : [Ben08] axioms.
% English  :

% Refs     : [Fit07] Fitting (2007), Modal Proof Theory
%          : [Ben08] Benzmueller (2008), Email to G. Sutcliffe
% Source   : [Ben08]
% Names    : Fitting-HB-11 [Ben08]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.11 v7.3.0
% Syntax   : Number of formulae    :   38 (   0 unit;  21 type;  15 defn)
%            Number of atoms       :  101 (  15 equality;  46 variable)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   57 (   3   ~;   1   |;   2   &;  50   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   83 (  83   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   26 (  21   :;   0   =)
%            Number of variables   :   38 (   2 sgn;   6   !;   4   ?;  28   ^)
%                                         (  38   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
% Bugfixes : v7.3.0 - Made relation R a constant.
%------------------------------------------------------------------------------
%----Include simple maths definitions and axioms
include('Axioms/LCL008^0.ax').
%------------------------------------------------------------------------------
%----Axioms
thf(r_type,type,(
    r: $i > $i > $o )).

thf(gl,axiom,(
    ! [X: $i > $o] :
      ( mvalid @ ( mimpl @ ( mbox @ r @ ( mimpl @ ( mbox @ r @ X ) @ X ) ) @ ( mbox @ r @ X ) ) ) )).

%----Conjecture
thf(loeb,conjecture,(
    ! [P: $i > $o] :
      ( mvalid @ ( mimpl @ ( mbox @ r @ ( mimpl @ ( mbox @ r @ P ) @ P ) ) @ ( mbox @ r @ P ) ) ) )).

%------------------------------------------------------------------------------
